# A function for plotting

myplot <- function(obj, w, main, ylab){
  
  P <- m$p
  beta <- obj$coefficients[w,]
  se <- sapply(vcov(obj), function(x,j){sqrt(x[j,j])}, j = w)
  low <- beta - 1.96*se
  up <- beta + 1.96*se
  
  # ylim
  r1 <- min(low)
  r2 <- max(up)
  rr <- r2 - r1
  r1 <- r1 - 0.1*rr
  r2 <- r2 + 0.1*rr
  
  
  plot(0,0, col = "white", xlim = c(0,1),  
     xlab = "p", ylab = ylab, main = main, 
     axes = FALSE, cex.lab = 1.5, ylim = c(r1,r2), cex.main = 1.25)

  yy <- c(low, tail(up, 1), rev(up), low[1])
  xx <- c(P, tail(P, 1), rev(P), P[1])
  polygon(xx, yy, col = "grey", border = NA)
  points(P, beta, type = "l", lwd = 2)
  axis(1, at = c(-1,0,0.2,0.4,0.6,0.8,1,2), cex.axis = 1.25)
  
  # A decent y axis
  axis(2, at = c(-100,100))
  a2 <- axis(2, col = "white", labels = FALSE)
  s2 <- sign(a2); s2 <- ifelse(sign(a2) == -1, "-", "")
  labs <- paste0(s2, substr(abs(a2), 2,nchar(abs(a2)))); labs[labs == ""] <- 0
  a2 <- axis(2, at = a2, cex.axis = 1.25, labels = labs)

  abline(h = 0, lty = 3, lwd = 2)
}


library(ctqr) # version 2.0, requires pch >= 2.0
library(bayesSurv) # Alternative sources: tandmobAll{icensBKL}, Tandmob{mixAK}
data(tandmob2)
d <- tandmob2

##################################################################################################

# First/Last ever examination: I use the smallest/largest examination time. I need these variables
  # only for those who already had an event at the first examination and are left-censored, and 
  # for those who still did not have an event at the last examination and are right-censored.

times <- cbind(d[, grep("BEG.", names(d), fixed = TRUE)], d[, grep("END.", names(d), fixed = TRUE)])
firstEx <- apply(times,1,min, na.rm = TRUE)
lastEx <- apply(times,1,max, na.rm = TRUE)

##################################################################################################

# Define a new variable: time to first premolar emergence.
# If any of the "EBEG" variables (left extreme of the interval) is left-censored,
  # then also the time to first premolar emergence is left-censored.
# Instead, if any of the "EEND" variables (right extreme of the interval) is *NOT* right-censored,
  # then also the time to first premolar emergence is *NOT* right-censored.

premolars <- sort(c(14, 24, 34, 44, 15, 25, 35, 45))
dL <- d[,paste0("EBEG.", premolars)]
dR <- d[,paste0("EEND.", premolars)]
L <- apply(dL,1,min); L[is.na(L)] <- -Inf # -Inf if left-censored
R <- apply(dR,1,min, na.rm = TRUE) # Inf if right-censored 
R[L == -Inf] <- firstEx[L == -Inf] # left-censored: (-Inf, firstEx)
L[R == Inf] <- lastEx[R == Inf] # right-censored: (lastEx, Inf)

##################################################################################################

# Indicators of oral health

BAD <- as.matrix(d[,grep("BAD", names(d))])
DMF <- as.matrix(d[,grep("DMF", names(d))])
CAR <- as.matrix(d[,grep("CAR", names(d))])

f1 <- function(x){any(is.na(x))}

mean(is.na(BAD))
mean(apply(BAD,1, f1))

mean(is.na(DMF))
mean(apply(DMF,1, f1))

mean(is.na(CAR))
mean(apply(CAR,1, f1))


BAD <- rowSums(BAD, na.rm = TRUE) # no missing values here
DMF <- rowSums(DMF, na.rm = TRUE) # NAs (0.7%) treated as zeroes
CAR <- rowSums(CAR, na.rm = TRUE) # NAs (0.6%) treated as zeroes

##################################################################################################

# Final data
# Note: STARTBR and FLUOR not used (many missing data)
dat <- data.frame(L = L, R = R, GENDER = d$GENDER, EDUC = d$EDUC, BAD, DMF, CAR)

##################################################################################################
##################################################################################################
##################################################################################################

P <- (1:19)/20
system.time(m <- ctqr(Surv(L,R, type = "interval2") ~ factor(EDUC) + GENDER + DMF + DMF*GENDER, data = dat, p = P))


# For comparison, I also fit Yang et al (2018)
library(DArq)
library(quantreg)
tL <- dat$L; tR <- dat$R; X <- model.matrix(m, data = dat)[,-1]
delta <- rep(3, nrow(dat)); delta[dat$L == -Inf] <- 1; delta[dat$R == Inf] <- 2
y <- (tL + tR)/2; y[tL == -Inf] <- tR[tL == -Inf]; y[tR == Inf] <- tL[tR == Inf] # totally absurd. Why do I need to supply y, tL, tR? Obviously tL and tR is enough.
system.time(m_YNH <- suppressWarnings(DArq(y, X, delta = delta, tL, tR, taus = P, iter = 100, tol = 0.01)))
plot(m$coef, m_YNH$coef); abline(0,1)


### PLEASE PAY ATTENTION: IN WHICH FOLDER ARE YOU CREATING THE FIGURE?
setwd("C:/Users/paofru/Desktop/ctqr/interval censored/paper icqr/latex files/latex files")
pdf("fig1.pdf", width = 7, height = 10.5)
par(mfrow = c(3,2), mai = c(1.02,1.5,0.82,0.42), mar = c(4,5,4,3))
myplot(m, w = 1, main = "Intercept", ylab = expression(hat(beta)[0](p)))
myplot(m, w = 2, main = "Attending a community school", ylab = expression(hat(beta)[1](p)))
myplot(m, w = 3, main = "Attending a province/council school", ylab = expression(hat(beta)[2](p)))
myplot(m, w = 4, main = "Girl", ylab = expression(hat(beta)[3](p)))
myplot(m, w = 5, main = "dmftScore", ylab = expression(hat(beta)[4](p)))
myplot(m, w = 6, main = "Girl x dmftScore", ylab = expression(hat(beta)[5](p)))
dev.off()

M <- summary(m)$coefficients
round(M[["p = 0.1"]],2)
round(M[["p = 0.25"]],2)
round(M[["p = 0.5"]],2)
round(M[["p = 0.75"]],2)
round(M[["p = 0.9"]],2)



